// DemoDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Demo.h"
#include "DemoDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDemoDlg dialog

CDemoDlg::CDemoDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDemoDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDemoDlg)
	m_innerbevelbtn = 0;
	m_orientationbtn = 0;
	m_outerbevelbtn = 1;
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CDemoDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDemoDlg)
	DDX_Control(pDX, IDC_POS, m_pos);
	DDX_Control(pDX, 1013, m_slider);
	DDX_Radio(pDX, IDC_RADIO8, m_innerbevelbtn);
	DDX_Radio(pDX, IDC_RADIO5, m_orientationbtn);
	DDX_Radio(pDX, IDC_RADIO3, m_outerbevelbtn);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDemoDlg, CDialog)
	//{{AFX_MSG_MAP(CDemoDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_RADIO8, OnRadio8)
	ON_BN_CLICKED(IDC_RADIO7, OnRadio7)
	ON_BN_CLICKED(IDC_RADIO6, OnRadio6)
	ON_BN_CLICKED(IDC_RADIO3, OnRadio3)
	ON_BN_CLICKED(IDC_RADIO2, OnRadio2)
	ON_BN_CLICKED(IDC_RADIO1, OnRadio1)
	ON_BN_CLICKED(IDC_RADIO5, OnRadio5)
	ON_BN_CLICKED(IDC_RADIO4, OnRadio4)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDemoDlg message handlers

BOOL CDemoDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CDemoDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

HCURSOR CDemoDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

BEGIN_EVENTSINK_MAP(CDemoDlg, CDialog)
    //{{AFX_EVENTSINK_MAP(CDemoDlg)
	ON_EVENT(CDemoDlg, 1013, 1 /* Scroll */, OnScrollSlider, VTS_I2)
	ON_EVENT(CDemoDlg, 1011, 1 /* Scroll */, OnScrollTickMarks, VTS_I2)
	ON_EVENT(CDemoDlg, 1012, 1 /* Scroll */, OnScrollCenterBar, VTS_I2)
	ON_EVENT(CDemoDlg, 1010, 1 /* Scroll */, OnScrollBorderWidth, VTS_I2)
	ON_EVENT(CDemoDlg, 1009, 1 /* Scroll */, OnScrollInnerBevelWidth, VTS_I2)
	ON_EVENT(CDemoDlg, 1008, 1 /* Scroll */, OnScrollOuterBevelWidth, VTS_I2)
	//}}AFX_EVENTSINK_MAP
END_EVENTSINK_MAP()

void CDemoDlg::OnScrollSlider(short value) 
{
	CString temp;
	temp.Format("%d", value);
	m_pos.SetWindowText(temp);
	
}

void CDemoDlg::OnScrollTickMarks(short value) 
{
	m_slider.SetTickMarks(value);	
}

void CDemoDlg::OnScrollCenterBar(short value) 
{
	m_slider.SetCenterBar(value);	
}

void CDemoDlg::OnScrollBorderWidth(short value) 
{
	m_slider.SetBorderWidth(value);	
}

void CDemoDlg::OnScrollInnerBevelWidth(short value) 
{
	m_slider.SetInnerBevelWidth(value);	
}

void CDemoDlg::OnScrollOuterBevelWidth(short value) 
{
	m_slider.SetOuterBevelWidth(value);	
}

void CDemoDlg::OnRadio8() 
{
	UpdateData();
	m_slider.SetInnerBevel(m_innerbevelbtn);
}

void CDemoDlg::OnRadio7() 
{
	OnRadio8();
}

void CDemoDlg::OnRadio6() 
{
	OnRadio8();
}

void CDemoDlg::OnRadio3() 
{
	UpdateData();
	m_slider.SetOuterBevel(m_outerbevelbtn);
}

void CDemoDlg::OnRadio2() 
{
	OnRadio3();
}

void CDemoDlg::OnRadio1() 
{
	OnRadio3();
}

void CDemoDlg::OnRadio5() 
{
	UpdateData();
	m_slider.SetOrientation(m_orientationbtn);
	m_slider.MoveWindow(17, 96, 201, 32);
}

void CDemoDlg::OnRadio4() 
{
	UpdateData();
	m_slider.SetOrientation(m_orientationbtn);
	m_slider.MoveWindow(98, 7, 31, 173);
}
